package org.amse.mm.myVirtualBilliards.view;
 
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.filechooser.FileFilter;

import org.amse.mm.*;
import org.amse.mm.io.*;
import org.amse.mm.myVirtualBilliards.model.*;

public class PaintTable extends JFrame{
	public PaintTable(ITable table, ICue cue){
		super("VirtualBilliards");
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		initialize(table, cue);
	
		JLayeredPane lp = getLayeredPane();
		TablePainting tablePainting = new TablePainting();		
		tablePainting.setBounds(myX - myCueLength, myY - myCueLength,
								myX + myWidthT + 2 * myRadiusOut + myCueLength, 
								myY + myLengthT + 2 * myRadiusOut + myCueLength);
		lp.add(tablePainting, JLayeredPane.DEFAULT_LAYER);
		setLayeredPane(lp);
		
		JMenuBar menuBar = new JMenuBar();
		menuBar.add(createFileMenu());
		menuBar.add(createPropertyMenu());
		setJMenuBar(menuBar);
		
		setSize(800, 800);
		setLocation(150, 10);
		setVisible(true);
	}
	
	private void saveGame(){
		JFileChooser fc = new JFileChooser();
		fc.setDialogTitle("Save as");
		fc.setFileFilter(new FileFilter(){
			public boolean accept(java.io.File file){
				if (file.isDirectory()){
					return true;
				}
				return (file.getName().endsWith("bll"));
			}
			public String getDescription(){
				return "Files(*.bll)";
			}
		});
		
		File dirFile = new File(System.getProperty("user.dir"));
		dirFile.mkdir();
		fc.setCurrentDirectory(dirFile);
		
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
		int result = fc.showSaveDialog(PaintTable.this);
		if (result == JFileChooser.APPROVE_OPTION){
			try{
				File file = fc.getSelectedFile();
				if (! (file.getName().endsWith("bll"))){
					file = new File(file.getAbsolutePath() + ".bll");
				}
				OutputStream stream = new FileOutputStream(file);
				XMLWriter writer = new XMLWriter();
				writer.write(myInnerTable, stream, true);
			}catch(Exception ex){
				System.out.println("can't save");
				ex.printStackTrace();
			}
		}
	
		else{
			JOptionPane.showMessageDialog(PaintTable.this , "File not saved");
		}
	}
	
	private JMenu createPropertyMenu(){
		JMenu property = new JMenu("Property");
		JMenuItem friction = new JMenuItem(new AbstractAction("Friction"){
			public void actionPerformed(ActionEvent e){
				String result = JOptionPane.showInputDialog(PaintTable.this, 
						"input friction", String.valueOf(myInnerTable.getFriction()));
				if (result != null){
					myInnerTable.setFriction(Double.parseDouble(result));
					try{
						OutputStream stream = new FileOutputStream("initialize/friction.bll");
						XMLWriter writer = new XMLWriter();
						writer.write(myInnerTable, stream, false);
					}catch(Exception ex){
						System.out.println("can't load");
						ex.printStackTrace();
					}
				}
			}
		});
		friction.setAccelerator(KeyStroke.getKeyStroke("shift f"));
		
		property.add(friction);
		return property;
	}
	
	
	private JMenu createFileMenu(){
		JMenu file = new JMenu("File");
		JMenuItem newGame = new JMenuItem(new AbstractAction("New game"){
			public void actionPerformed(ActionEvent e){
				if (MyIsModelChanged){
					int result = JOptionPane.showConfirmDialog(PaintTable.this,
														   "Save this game?");
					if (result == JOptionPane.YES_OPTION){
						saveGame();
					}
					MyIsModelChanged = false;
				}
				ReadFromJar reader = new ReadFromJar(myInnerTable, "initialize/initial.bll", true);
				reader.init();
			}
		}); 
		newGame.setAccelerator(KeyStroke.getKeyStroke("shift n"));
		
		JMenuItem load = new JMenuItem(new AbstractAction("Load"){
			public void actionPerformed(ActionEvent e){
				Main.MyIsGameChecked = false;
				if (MyIsModelChanged){
					int result = JOptionPane.showConfirmDialog(PaintTable.this,
														   "Save this game?");
					if (result == JOptionPane.YES_OPTION){
						saveGame();
					}
					MyIsModelChanged = false;
				}
				
				JFileChooser fc = new JFileChooser();
				fc.setDialogTitle("Choose file");
				fc.setFileFilter(new FileFilter(){
					public boolean accept(java.io.File file){
						if (file.isDirectory()){
							return true;
						}
						return (file.getName().endsWith("bll"));
					}
					public String getDescription(){
						return "Files(*.bll)";
					}
				});
				
				File dirFile = new File(System.getProperty("user.dir"));
				dirFile.mkdir();
				fc.setCurrentDirectory(dirFile);
				
				fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int result = fc.showOpenDialog(PaintTable.this);
				if (result == JFileChooser.APPROVE_OPTION){
					try{
						InputStream stream = new FileInputStream(fc.getSelectedFile());
						XMLReader reader = new XMLReader(stream, myInnerTable, true);
						reader.parse();
					}catch(Exception ex){
						System.out.println("can't load");
						ex.printStackTrace();
					}
				}
				Main.MyIsGameChecked = true;
			}
		});
		load.setAccelerator(KeyStroke.getKeyStroke("shift l"));
		
		JMenuItem save = new JMenuItem(new AbstractAction("Save"){
			public void actionPerformed(ActionEvent e){
				saveGame();
				MyIsModelChanged = false;
			}
		});
		save.setAccelerator(KeyStroke.getKeyStroke("shift s"));
		
		JMenuItem exit = new JMenuItem(new AbstractAction("Exit"){
			public void actionPerformed(ActionEvent e){
				if (MyIsModelChanged){
					int result = JOptionPane.showConfirmDialog(PaintTable.this,
														   "Save this game?");
					if (result == JOptionPane.YES_OPTION){
						saveGame();
					}
					MyIsModelChanged = false;
				}
				System.exit(0);
			}
		});
		exit.setAccelerator(KeyStroke.getKeyStroke("shift q"));
		
		file.add(newGame);
		file.addSeparator();
		file.add(save);
		file.add(load);
		file.addSeparator();
		file.add(exit);
		return file;
	}
		
	private static final int SCALE = 2;
	public boolean MyIsModelChanged;
	private ITable myInnerTable;
	private ICue myCue;
	private int myX = 200;
	private int myY = 120;
	private int myRadiusOut;
	private int myRadiusInside;
	private int myDiameterBall;
	private int myLengthT;
	private int myWidthT;
	private int myCueLength;
	private int myCueWidth;
	
	public void initialize(ITable table, ICue cue){
		myInnerTable = table;
		myCue = cue;
		myRadiusOut = ITable.WIDTH_BOARD * SCALE / 2 * 2 + 1;
		myRadiusInside = ITable.RADIUS_POCKET * SCALE;
		myDiameterBall = ITable.DIAMETER_BALL * SCALE;
		myLengthT = (ITable.LENGTH_TABLE + ITable.DIAMETER_BALL) * SCALE;
		myWidthT = (ITable.WIDTH_TABLE + ITable.DIAMETER_BALL) * SCALE;
		myCueLength = (ICue.LENGTH_CUE) * SCALE;
		myCueWidth = (ICue.WIDTH_CUE) * SCALE;
		MyIsModelChanged = false;
	}
	
	class TablePainting extends JComponent{
		public void paint(Graphics g){
			super.paintComponent(g);
			
			g.setColor(Color.white);
			g.fillOval(myX, myY, 2 * myRadiusOut, 2 * myRadiusOut);
			g.fillOval(myX, myY + myLengthT, 2 * myRadiusOut, 2 * myRadiusOut);
			g.fillOval(myX + myWidthT, myY, 2 * myRadiusOut, 2 * myRadiusOut);
			g.fillOval(myX + myWidthT, myY + myLengthT, 2 * myRadiusOut, 2 * myRadiusOut);
			
			g.fillRect(myX + myRadiusOut, myY, myRadiusInside, myLengthT + 2 * myRadiusOut);
			g.fillRect(myX + myWidthT + myRadiusOut - myRadiusInside,
    				   myY, myRadiusInside, myLengthT + 2 * myRadiusOut);
			g.fillRect(myX, myY + myRadiusOut, myWidthT + 2 * myRadiusOut, myRadiusInside);
			g.fillRect(myX , myY + myLengthT + myRadiusOut - myRadiusInside, 
					   myWidthT + 2 * myRadiusOut, myRadiusInside);
			
			g.setColor(Color.LIGHT_GRAY);
			g.fillRect(myX + myRadiusOut + myRadiusInside, myY,
					   myWidthT - 2 * myRadiusInside, myRadiusOut);
			g.fillRect(myX, myY + myRadiusOut + myRadiusInside, 
					   myRadiusOut, myLengthT - 2 * myRadiusInside);
			g.fillRect(myX + myRadiusOut + myRadiusInside, myY + myLengthT + myRadiusOut, 
					   myWidthT - 2 * myRadiusInside, myRadiusOut);
			g.fillRect(myX + myWidthT + myRadiusOut, myY + myRadiusOut + myRadiusInside, 
					   myRadiusOut, myLengthT - 2 * myRadiusInside);

			g.setColor(Color.white);
			g.fillRect(myX, myY + (myLengthT + myRadiusInside) / 2, 
					   myWidthT + 2 * myRadiusOut, 2 * myRadiusInside);
						
			g.setColor(Color.green);
			g.fillRect(myX + myRadiusOut, myY + myRadiusOut, myWidthT, myLengthT);
			
			g.setColor(Color.gray);
			g.fillOval(myX + (myRadiusOut - myRadiusInside), myY + (myLengthT + myRadiusInside) / 2,
				   	   2 * myRadiusInside, 2 * myRadiusInside);	
			g.fillOval(myX + myWidthT + (myRadiusOut - myRadiusInside), myY + 
				 	  (myLengthT + myRadiusInside) / 2, 2 * myRadiusInside, 2 * myRadiusInside);
			
			g.setColor(Color.gray);
			g.fillOval(myX + (myRadiusOut - myRadiusInside), myY + (myRadiusOut - myRadiusInside),
					   2 * myRadiusInside, 2 * myRadiusInside);
			g.fillOval(myX + (myRadiusOut - myRadiusInside), myY + (myRadiusOut - myRadiusInside) +
					   myLengthT, 2 * myRadiusInside, 2 * myRadiusInside);
			g.fillOval(myX + (myRadiusOut - myRadiusInside) + myWidthT, myY + 
					  (myRadiusOut - myRadiusInside), 2 * myRadiusInside, 2 * myRadiusInside);
			g.fillOval(myX + (myRadiusOut - myRadiusInside) + myWidthT, myY +
					  (myRadiusOut - myRadiusInside) + myLengthT, 2 * myRadiusInside, 2 * myRadiusInside);

			

			for (IBall ball : myInnerTable.balls()){
				if (ball != null){
					g.setColor(ballColor(ball.getColor()));
					g.fillOval(myX + myRadiusOut + (int)(ball.getCoordinate().X * SCALE + 0.5), 
							myY + myRadiusOut + (int)(ball.getCoordinate().Y * SCALE + 0.5),
							myDiameterBall, myDiameterBall);
				}
			}
			
			if (! myInnerTable.areBallsMoving()){
				IBall tmpBall = null;
				for(IBall ball : myInnerTable.balls()){
					if (ball.getColor() == BallColor.WHITE){
						tmpBall = ball;
					}
				}
				
				if (tmpBall != null){
				
					g.setColor(Color.DARK_GRAY);
					int tmpX = myX + myRadiusOut + (int)(tmpBall.getCoordinate().X *
							SCALE + 0.5) + (int)(myDiameterBall / 2 + 0.5);
					int tmpY = myY + myRadiusOut + (int)(tmpBall.getCoordinate().Y * 
							SCALE + 0.5) + (int)(myDiameterBall / 2 + 0.5);
					g.drawLine(tmpX, tmpY,
							tmpX + (int)(myCueLength * Math.cos(myCue.getAngle()) + 0.5),
							tmpY + (int)(myCueLength * Math.sin(myCue.getAngle()) + 0.5));
					g.setColor(Color.RED);
					g.drawPolyline(new int[] {tmpX - (int)((myDiameterBall + 10 * myCue.getForce()) * Math.cos(myCue.getAngle()) +
										  (myCueWidth / 2) * Math.sin(myCue.getAngle())),
										  tmpX - (int)((myDiameterBall + myCueLength + 10 * myCue.getForce()) * Math.cos(myCue.getAngle()) +
										  myCueWidth * Math.sin(myCue.getAngle())),
										  tmpX - (int)((myDiameterBall + myCueLength + 10 * myCue.getForce()) * Math.cos(myCue.getAngle()) -
										  myCueWidth * Math.sin(myCue.getAngle())),
										  tmpX - (int)((myDiameterBall + 10 * myCue.getForce()) * Math.cos(myCue.getAngle()) -
										  (myCueWidth / 2) * Math.sin(myCue.getAngle())),
										  tmpX - (int)((myDiameterBall + 10 * myCue.getForce()) * Math.cos(myCue.getAngle()) + 
										  (myCueWidth / 2) * Math.sin(myCue.getAngle()))},
							   new int[] {tmpY - (int)((myDiameterBall + 10 * myCue.getForce()) * Math.sin(myCue.getAngle()) - 
									   	  (myCueWidth / 2) * Math.cos(myCue.getAngle())),
										  tmpY - (int)((myDiameterBall + myCueLength + 10 * myCue.getForce()) * Math.sin(myCue.getAngle()) - 
										  myCueWidth * Math.cos(myCue.getAngle())),
										  tmpY - (int)((myDiameterBall + myCueLength + 10 * myCue.getForce()) * Math.sin(myCue.getAngle()) +
										  myCueWidth * Math.cos(myCue.getAngle())),
										  tmpY - (int)((myDiameterBall + 10 * myCue.getForce()) * Math.sin(myCue.getAngle()) + 
										  (myCueWidth / 2) * Math.cos(myCue.getAngle())),
										  tmpY - (int)((myDiameterBall + 10 * myCue.getForce()) * Math.sin(myCue.getAngle()) - 
										  (myCueWidth / 2) * Math.cos(myCue.getAngle()))},
							   5);		
				
				}
			}else{
				MyIsModelChanged = true;
			}

		}
		
		private Color ballColor (BallColor bc){
			switch (bc){
			case WHITE:
				return Color.WHITE;
			case BLACK:
				return Color.BLACK;
			case RED:
				return Color.RED;
			case BLUE:
				return Color.BLUE;
			case YELLOW:
				return Color.YELLOW;
			case ORANGE:
				return Color.ORANGE;
			case PINK:	
				return Color.PINK;
			case MAGENTA:
				return Color.MAGENTA;
			case CYAN:
				return Color.CYAN;
			case LIGHT_GRAY:
				return Color.LIGHT_GRAY;
			}
			return Color.GREEN;
		}
	}


}
